<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
        .content { background: #f9f9f9; padding: 30px; border-radius: 0 0 10px 10px; }
        .button { display: inline-block; padding: 15px 30px; background: #667eea; color: white; text-decoration: none; border-radius: 5px; margin: 20px 0; }
        .footer { text-align: center; margin-top: 20px; color: #666; font-size: 12px; }
    </style>
</head>
<body>
    <div class='container'>
        <div class='header'>
            <h1>Welcome to Student Registration System</h1>
        </div>
        <div class='content'>
            <p>Hello <strong><?php echo htmlspecialchars($firstname); ?></strong>,</p>
            <p>Thank you for registering with us! Please verify your email address to complete your registration.</p>
            <p>Click the button below to verify your email:</p>
            <p style='text-align: center;'>
                <a href='<?php echo $verification_link; ?>' class='button'>Verify Email Address</a>
            </p>
            <p>Or copy and paste this link into your browser:</p>
            <p style='word-break: break-all; background: white; padding: 10px; border-radius: 5px;'><?php echo $verification_link; ?></p>
            <p><strong>Note:</strong> If you did not register for this account, please ignore this email.</p>
        </div>
        <div class='footer'>
            <p>&copy; <?php echo date('Y'); ?> Student Registration System. All rights reserved.</p>
        </div>
    </div>
</body>
</html>