<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Registration</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }

        .container {
            background: white;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 500px;
        }

        h2 {
            color: #333;
            margin-bottom: 30px;
            text-align: center;
            font-size: 28px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            margin-bottom: 8px;
            color: #555;
            font-weight: 500;
        }

        input, select {
            width: 100%;
            padding: 12px;
            border: 2px solid #e0e0e0;
            border-radius: 5px;
            font-size: 14px;
            transition: border-color 0.3s;
        }

        input:focus, select:focus {
            outline: none;
            border-color: #667eea;
        }

        .btn {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s;
        }

        .btn:hover {
            transform: translateY(-2px);
        }

        .alert {
            padding: 12px;
            border-radius: 5px;
            margin-bottom: 20px;
            text-align: center;
        }

        .alert-success {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }

        .required {
            color: red;
        }

        .back-link {
            text-align: center;
            margin-top: 20px;
        }

        .back-link a {
            color: #667eea;
            text-decoration: none;
            font-weight: 500;
        }

        .back-link a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Student Registration</h2>
        
        <?php if ($this->session->flashdata('success')): ?>
            <div class="alert alert-success">
                <?php echo $this->session->flashdata('success'); ?>
            </div>
        <?php endif; ?>
        
        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-error">
                <?php echo $this->session->flashdata('error'); ?>
            </div>
        <?php endif; ?>

        <?php echo form_open('registration/save', array('id' => 'registrationForm')); ?>
            <div class="form-group">
                <label for="studentno">Student Number <span class="required">*</span></label>
                <?php echo form_input(array(
                    'name' => 'studentno',
                    'id' => 'studentno',
                    'required' => 'required',
                    'value' => set_value('studentno')
                )); ?>
            </div>

            <div class="form-group">
                <label for="lastname">Last Name <span class="required">*</span></label>
                <?php echo form_input(array(
                    'name' => 'lastname',
                    'id' => 'lastname',
                    'required' => 'required',
                    'value' => set_value('lastname')
                )); ?>
            </div>

            <div class="form-group">
                <label for="firstname">First Name <span class="required">*</span></label>
                <?php echo form_input(array(
                    'name' => 'firstname',
                    'id' => 'firstname',
                    'required' => 'required',
                    'value' => set_value('firstname')
                )); ?>
            </div>

            <div class="form-group">
                <label for="course">Course <span class="required">*</span></label>
                <?php 
                $courses = array(
                    '' => 'Select Course',
                    'Computer Science' => 'Computer Science',
                    'Information Technology' => 'Information Technology',
                    'Business Administration' => 'Business Administration',
                    'Engineering' => 'Engineering',
                    'Education' => 'Education'
                );
                echo form_dropdown('course', $courses, set_value('course'), 'id="course" required');
                ?>
            </div>

            <div class="form-group">
                <label for="emailaddress">Email Address <span class="required">*</span></label>
                <?php echo form_input(array(
                    'type' => 'email',
                    'name' => 'emailaddress',
                    'id' => 'emailaddress',
                    'required' => 'required',
                    'value' => set_value('emailaddress')
                )); ?>
            </div>

            <div class="form-group">
                <label for="contactno">Contact Number <span class="required">*</span></label>
                <?php echo form_input(array(
                    'type' => 'tel',
                    'name' => 'contactno',
                    'id' => 'contactno',
                    'pattern' => '[0-9]{10,11}',
                    'placeholder' => 'e.g., 09123456789',
                    'required' => 'required',
                    'value' => set_value('contactno')
                )); ?>
            </div>

            <button type="submit" class="btn">Register</button>
        <?php echo form_close(); ?>

        <div class="back-link">
            <a href="<?php echo base_url(); ?>">← Back to Home</a>
        </div>
    </div>
</body>
</html>