<!DOCTYPE html>
<html>
<head>
    <title>Student QR Generator</title>

    <style>
        body {
            margin: 0;
            font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
            background: #eef1f5;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            background: #ffffff;
            padding: 40px 45px;
            border-radius: 12px;
            width: 380px;
            box-shadow: 0 5px 25px rgba(0,0,0,0.12);
            text-align: center;
        }
        input {
            width: 100%;
            padding: 12px;
            margin-bottom: 15px;
            border: 1px solid #ddd;
            border-radius: 4px;
            box-sizing: border-box;
        }
        button {
            width: 100%;
            padding: 12px;
            background: #0a6cff;
            color: #fff;
            border: none;
            cursor: pointer;
            border-radius: 4px;
            font-size: 16px;
        }
        button:hover {
            background: #0858d1;
        }
        button:disabled {
            background: #ccc;
            cursor: not-allowed;
        }
        #qrResult img {
            margin-top: 20px;
            width: 200px;
        }
        .success-msg {
            color: #28a745;
            margin-top: 15px;
        }
        .error-msg {
            color: #dc3545;
            margin-top: 15px;
        }
    </style>
</head>
<body>

<div class="container">

    <h3>Student QR Generator</h3>

    <form id="studentForm" method="post">
        <input type="text" name="student_name" placeholder="Student Name" required>
        <input type="text" name="student_id" placeholder="Student ID" required>
        <input type="text" name="course" placeholder="Course" required>
        <input type="text" name="year_level" placeholder="Year Level" required>
        <button type="submit" id="submitBtn">Generate QR</button>
    </form>

    <div id="qrResult"></div>

</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
$(document).ready(function(){

    $('#studentForm').on('submit', function(e){
        e.preventDefault(); // stop reload

        // Disable submit button
        $('#submitBtn').prop('disabled', true).text('Generating...');

        let data = {
            student_name: $('input[name="student_name"]').val(),
            student_id: $('input[name="student_id"]').val(),
            course: $('input[name="course"]').val(),
            year_level: $('input[name="year_level"]').val()
        };

        // Build QR text
        data.qrtext =
            "Name: " + data.student_name + "\n" +
            "ID: " + data.student_id + "\n" +
            "Course: " + data.course + "\n" +
            "Year Level: " + data.year_level;

        console.log('Sending data:', data);

        $.ajax({
            url: "<?= base_url('appcontroller/savecode'); ?>",
            type: "POST",
            data: data,
            dataType: "json",

            success: function(res){
                console.log('Response:', res);

                $('#submitBtn').prop('disabled', false).text('Generate QR');

                if(res.status === 'success'){
                    $('#qrResult').html(
                        '<p class="success-msg"><strong>QR Generated Successfully!</strong></p>' +
                        '<img src="<?= base_url('assets/qrcode/'); ?>' + res.qr_image + '" alt="QR Code">'
                    );
                    
                    // Clear form
                    $('#studentForm')[0].reset();
                } else {
                    $('#qrResult').html(
                        '<p class="error-msg">' + (res.message || 'Failed to generate QR code') + '</p>'
                    );
                }
            },

            error: function(xhr, status, error){
                console.error('AJAX Error:', xhr.responseText);
                $('#submitBtn').prop('disabled', false).text('Generate QR');
                
                $('#qrResult').html(
                    '<p class="error-msg">Error: ' + error + '<br>Check console for details.</p>'
                );
            }
        });
    });

});
</script>

</body>
</html>