<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Student_model extends CI_Model {
    
    private $table = 'students';
    
    public function __construct() {
        parent::__construct();
        $this->load->database();
    }
    
    public function insert_student($data) {
        // Generate verification token
        $token = bin2hex(random_bytes(32));
        
        $insert_data = array(
            'studentno' => $data['studentno'],
            'lastname' => $data['lastname'],
            'firstname' => $data['firstname'],
            'course' => $data['course'],
            'emailaddress' => $data['emailaddress'],
            'contactno' => $data['contactno'],
            'verification_token' => $token,
            'is_verified' => 0,
            'created_at' => date('Y-m-d H:i:s')
        );
        
        if ($this->db->insert($this->table, $insert_data)) {
            return array(
                'status' => TRUE,
                'token' => $token,
                'email' => $data['emailaddress']
            );
        }
        
        return array('status' => FALSE);
    }
    
    public function check_email_exists($email) {
        $this->db->where('emailaddress', $email);
        $query = $this->db->get($this->table);
        return $query->num_rows() > 0;
    }
    
    public function check_studentno_exists($studentno) {
        $this->db->where('studentno', $studentno);
        $query = $this->db->get($this->table);
        return $query->num_rows() > 0;
    }
    
    public function verify_email($token) {
        $this->db->where('verification_token', $token);
        $this->db->where('is_verified', 0);
        
        $update_data = array(
            'is_verified' => 1,
            'verified_at' => date('Y-m-d H:i:s')
        );
        
        $this->db->update($this->table, $update_data);
        
        return $this->db->affected_rows() > 0;
    }
    
    public function get_student_by_id($id) {
        $this->db->where('studentid', $id);
        $query = $this->db->get($this->table);
        return $query->row_array();
    }
    
    public function get_all_students() {
        $query = $this->db->get($this->table);
        return $query->result_array();
    }
}