<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class AppController extends CI_Controller {

    public function __construct(){
        parent::__construct();
        $this->load->library('session');
        $this->load->database();
        $this->load->helper('url');
        // Uncomment if you have the model
        // $this->load->model('AppModel');
    }

    public function index(){
        echo "Sample page";
    }

    public function generateqrcode(){
        $this->load->view('generateqrcode/generateqrcode');
    }

    /*QR CODE GENERATION FUNCTION*/
    public function generate_qrcode($data){
        $this->load->library('ciqrcode');

        $hex_data  = bin2hex($data);
        $save_name = $hex_data . '.png';

        $dir = 'assets/qrcode/';
        if (!file_exists($dir)) {
            mkdir($dir, 0775, true);
        }

        $config['cacheable'] = true;
        $config['imagedir']  = $dir;
        $config['quality']   = true;
        $config['size']      = '1024';
        
        // FIXED: Proper QR code colors (black and white)
        $config['black']     = array(0, 0, 0);      // Black for QR code
        $config['white']     = array(255, 255, 255); // White background

        $this->ciqrcode->initialize($config);

        $params['data']     = $data;
        $params['level']    = 'H';  // Changed to 'H' for better quality
        $params['size']     = 10;
        $params['savename'] = FCPATH . $dir . $save_name;

        $this->ciqrcode->generate($params);

        return array(
            'content' => $data,
            'file'    => $save_name
        );
    }

    /* SAVE STUDENT + QR (AJAX)*/
    public function savecode(){
        // Set JSON header
        header('Content-Type: application/json');

        // Log incoming data for debugging
        log_message('debug', 'POST data: ' . print_r($this->input->post(), true));

        $qrtext = $this->input->post('qrtext');

        if (empty($qrtext)) {
            echo json_encode(array(
                'status' => 'error',
                'message' => 'No QR data received'
            ));
            return;
        }

        try {
            // Generate QR code
            $qrcode = $this->generate_qrcode($qrtext);

            // Prepare data for database - UPDATED to match student_info table structure
            $data = array(
                'Name'       => $this->input->post('student_name'),  // Maps to 'Name' column
                'Course'     => $this->input->post('course'),        // Maps to 'Course' column
                'Year_level' => $this->input->post('year_level'),    // Maps to 'Year_level' column
                'qr_text'    => $qrtext,
                'qr_image'   => $qrcode['file']
            );

            // Insert into database - CHANGED to student_info table
            if ($this->db->insert('student_info', $data)) {
                echo json_encode(array(
                    'status'   => 'success',
                    'qr_image' => $qrcode['file'],
                    'message'  => 'Student record saved successfully'
                ));
            } else {
                // Get database error
                $error = $this->db->error();
                log_message('error', 'Database insert failed: ' . print_r($error, true));
                
                echo json_encode(array(
                    'status' => 'error',
                    'message' => 'Database insert failed: ' . $error['message']
                ));
            }
        } catch (Exception $e) {
            log_message('error', 'Exception: ' . $e->getMessage());
            echo json_encode(array(
                'status' => 'error',
                'message' => 'Exception: ' . $e->getMessage()
            ));
        }
    }

    public function sample(){
        echo "Sample sample";
    }

    /*QR CODE SCANNER VIEW*/
    public function scanqrcode(){
        $this->load->view('generateqrcode/scanqrcode');
    }

    /* SEARCH QR CODE IN DATABASE (AJAX) - NEW FUNCTION */
    public function searchqrcode(){
        // Set JSON header
        header('Content-Type: application/json');
        
        $qr_text = $this->input->post('qr_text');
        
        if (empty($qr_text)) {
            echo json_encode(array(
                'status' => 'error',
                'message' => 'No QR text provided'
            ));
            return;
        }
        
        try {
            // Search in database by qr_text
            $this->db->where('qr_text', $qr_text);
            $query = $this->db->get('student_info');
            
            if ($query->num_rows() > 0) {
                // Student found
                $student = $query->row_array();
                
                echo json_encode(array(
                    'status' => 'success',
                    'message' => 'Student found',
                    'data' => $student
                ));
            } else {
                // Student not found
                echo json_encode(array(
                    'status' => 'error',
                    'message' => 'Student not found in database'
                ));
            }
            
        } catch (Exception $e) {
            log_message('error', 'Search error: ' . $e->getMessage());
            echo json_encode(array(
                'status' => 'error',
                'message' => 'Database error: ' . $e->getMessage()
            ));
        }
    }
}